﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.OptionSets;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancelOutbound
{
    /// <summary>
    /// Get Clinics step.
    /// </summary>
    public class GetClinicsStep : FilterBase<MakeCancelOutboundStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(MakeCancelOutboundStateObject state)
        {
            if (state.AppointmentType != AppointmentType.HOME_MOBILE) state.PatientClinic = GetClinic(state, Side.Patient);
            if (state.AppointmentType != AppointmentType.STORE_FORWARD) state.ProviderClinic = GetClinic(state, Side.Provider);
        }

        /// <summary>
        /// Gets the Resource for the given Patient or Provider.
        /// </summary>
        /// <param name="state">State object.</param>
        /// <param name="side">Patient or Provider.</param>
        /// <returns>Resource.</returns>
        private static mcs_resource GetClinic(MakeCancelOutboundStateObject state, Side side)
        {
            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {
                var bookedResources = state.ServiceAppointment.Resources.Where(r => r.PartyId.LogicalName == "equipment").ToList();

                if (state.Appointment?.RequiredAttendees != null && side == Side.Patient && state.IsGroupAppointment)
                {
                    bookedResources.AddRange(state.Appointment.RequiredAttendees.Where(r => r.PartyId.LogicalName == "equipment").ToList());
                }

                if (bookedResources.Count < 1) throw new Exception($"No Valid Vista Clinics were found for the {side.ToString()} side");

                foreach (var equipmentParty in bookedResources)
                {
                    var resource = srv.mcs_resourceSet.FirstOrDefault(r => r.mcs_relatedResourceId != null && r.mcs_relatedResourceId.Id == equipmentParty.PartyId.Id);
                    if (resource == null) throw new Exception("The resource cannot be null");

                    if (resource.mcs_Type.Value != (int) mcs_resourcetype.VistaClinic) continue;
                    
                    if (side != Side.Patient)
                    {
                        if (state.ServiceAppointment.mcs_relatedprovidersite != null)
                        {
                            if (state.ServiceAppointment.mcs_relatedprovidersite.Id == resource.mcs_RelatedSiteId.Id) return resource;
                            Logger.Instance.Debug($"Vista Clinic Site doesn't match Provider Site, looking for next Vista Clinic: {resource.mcs_name}");
                        }
                        else throw new Exception("No Provider Site is listed");
                    }
                    else
                    {
                        if (!state.IsGroupAppointment && state.ServiceAppointment.mcs_relatedsite != null)
                        {
                            if (state.ServiceAppointment.mcs_relatedsite.Id == resource.mcs_RelatedSiteId.Id) return resource;
                            Logger.Instance.Debug($"Vista Clinic Site doesn't match Patient Site, looking for next Vista Clinic: {resource.mcs_name}");
                        }
                        else if (state.IsGroupAppointment && state.Appointment?.cvt_Site != null)
                        {
                            if (state.Appointment.cvt_Site.Id == resource.mcs_RelatedSiteId.Id) return resource;
                            Logger.Instance.Debug($"Vista Clinic Site doesn't match Patient Site, looking for next Vista Clinic: {resource.mcs_name}");
                        }
                        else throw new Exception("No Patient Site is listed");
                    }
                }

                throw new Exception($"No Valid Vista Clinics were found for the {side.ToString()} side");
            }
        }
    }
}